/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.client.render;

import com.dfdyz.epicacg.client.render.custom.BloomParticleRenderType;
import com.dfdyz.epicacg.client.render.custom.SpaceBrokenRenderType;
import com.dfdyz.epicacg.utils.RenderUtils;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.HashMap;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EpicACGRenderType {
    public static final ResourceLocation ChildSkillnoSelected = RenderUtils.GetTexture("gui/noselected");
    public static final ResourceLocation ChildSkillSelected = RenderUtils.GetTexture("gui/selected");
    public static final ResourceLocation GS_BOW_SHOOT_PARTICLE_TEX = RenderUtils.GetTexture("particle/genshin_bow");
    public static final ResourceLocation GS_BOW_LANDONG_PARTICLE_TEX = RenderUtils.GetTexture("particle/genshin_bow_landing");
    public static final ResourceLocation GS_BOW_LANDONG_PARTICLE_TEX3 = RenderUtils.GetTexture("particle/genshin_bow_landing3");
    public static final ResourceLocation BLACK_KNIGHT_PARTICLE_TEX = RenderUtils.GetTexture("particle/blackknight_hit");
    public static final ResourceLocation BLOOD_THIRSTY_PARTICLE_TEX = RenderUtils.GetTexture("particle/bloodthirsty_hit");
    public static final BloomParticleRenderType SAO_DEATH_PARTICLE = new BloomParticleRenderType(new ResourceLocation("epicacg", "sao_death"), RenderUtils.GetTexture("particle/sao_death"));
    private static int bloomIdx = 0;
    public static final HashMap<ResourceLocation, BloomParticleRenderType> BloomRenderTypes = Maps.newHashMap();
    private static int quadIdx = 0;
    public static final HashMap<ResourceLocation, EpicACGQuadParticleRenderType> QuadRenderTypes = Maps.newHashMap();
    public static SpaceBrokenRenderType SpaceBroken1 = new SpaceBrokenRenderType(new ResourceLocation("epicacg", "space_broken"), 0);
    public static SpaceBrokenRenderType SpaceBroken2 = new SpaceBrokenRenderType(new ResourceLocation("epicacg", "space_broken"), 1);
    public static SpaceBrokenRenderType SpaceBrokenEnd = new SpaceBrokenRenderType(new ResourceLocation("epicacg", "space_broken_end"), RenderUtils.GetTexture("particle/glass"), 0, 4);
    public static final ResourceLocation NoneTexture = RenderUtils.GetTexture("none");
    public static final ParticleRenderType TRANSLUCENT = new ParticleRenderType(){

        public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(GameRenderer::m_172835_);
            RenderUtils.GLSetTexture(NoneTexture);
            bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85820_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85915_().m_277127_(VertexSorting.f_276633_);
            tesselator.m_85914_();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
        }

        public String toString() {
            return "EPICACG:TRANSLUCENT";
        }
    };

    public static BloomParticleRenderType getBloomRenderTypeByTexture(ResourceLocation texture) {
        if (BloomRenderTypes.containsKey(texture)) {
            return BloomRenderTypes.get(texture);
        }
        BloomParticleRenderType bloomType = new BloomParticleRenderType(new ResourceLocation("epicacg", "bloom_particle_" + bloomIdx++), texture);
        BloomRenderTypes.put(texture, bloomType);
        return bloomType;
    }

    public static EpicACGQuadParticleRenderType getRenderTypeByTexture(ResourceLocation texture) {
        if (QuadRenderTypes.containsKey(texture)) {
            return QuadRenderTypes.get(texture);
        }
        EpicACGQuadParticleRenderType rdt = new EpicACGQuadParticleRenderType("epicacg:quad_particle_" + quadIdx++, texture);
        QuadRenderTypes.put(texture, rdt);
        return rdt;
    }

    public static ShaderInstance getPositionColorLightmapShader() {
        return GameRenderer.f_172587_;
    }

    public static class EpicACGQuadParticleRenderType
    implements ParticleRenderType {
        private final ResourceLocation Texture;
        private final String Name;

        public EpicACGQuadParticleRenderType(String name, ResourceLocation tex) {
            this.Texture = tex;
            this.Name = name;
        }

        public void m_6505_(BufferBuilder p_107448_, TextureManager p_107449_) {
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::m_172829_);
            if (this.Texture != null) {
                RenderUtils.GLSetTexture(this.Texture);
            }
            p_107448_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85915_().m_277127_(VertexSorting.f_276633_);
            tesselator.m_85914_();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
        }

        public String toString() {
            return this.Name;
        }
    }
}

